import numpy as np 
import os
import pdb
import matplotlib.pyplot as plt 
import math
import sys
sys.path.append(os.getcwd() + "/CreateDataset/")
from Dataset import GetMatchDataByDistance
from sklearn.metrics import f1_score
from statsmodels.stats.proportion import proportion_confint


# print statistics for the actve match pair experiment
def PrintStats(args, StatsPath, Stats, start, end):
	
	print("Trial:%d, TestType:%s, ScalingMethod:%s, Responding threshod:%.3f, Acquisition threshold:%.2f, Data Size: %d, Budget: %d, classifier:%s, Reject: %d  Label spent: %d, TPR: %.4f, TFR: %.4f, fscore: %.4f\n"%\
		(args.Trial,args.TestType, args.ScalingStrategy, args.RespondingThres, args.Thres, args.S, args.Budget, args.Bettingcls, Stats[0], Stats[1], Stats[2], Stats[3], Stats[4]))

	with open(StatsPath + "stats.txt", "a") as f:
		f.write("Trial:%d, TestType:%s, ScalingMethod:%s, Responding threshod:%.3f, Acquisition threshold:%.2f, Data Size: %d, Budget: %d, classifier:%s, Reject: %d  Label spent: %d, TPR: %.4f, FPR: %.4f, fscore: %.4f\n"%\
			(args.Trial,args.TestType, args.ScalingStrategy, args.RespondingThres, args.Thres, args.S, args.Budget, args.Bettingcls, Stats[0], Stats[1], Stats[2], Stats[3], Stats[4]))
	
def SetPltProp(ax, xn = None, yn=None, title=None, grid = True, bbox_to_anchor=None, legend = True, pos = 'upper left', borderpad=None, ylim = None):
	fontsize = 14
	for axis in ['top','bottom','left','right']:
		ax.spines[axis].set_linewidth(2.5)

	for tick in ax.xaxis.get_major_ticks():
		tick.label1.set_fontsize(fontsize)
		tick.label1.set_fontweight('bold')
	for tick in ax.yaxis.get_major_ticks():
		tick.label1.set_fontsize(fontsize)
		tick.label1.set_fontweight('bold') 

	if legend:  
		if bbox_to_anchor == None: 
			ax.legend(loc=pos, shadow=True, prop={'weight':'bold', 'size':10},  borderpad=borderpad)
		else:
			ax.legend(loc=pos, shadow=True, bbox_to_anchor =bbox_to_anchor, prop={'weight':'bold', 'size':10}, borderpad=borderpad)
	if ylim!=None:
		ax.set_ylim(ylim)
	if grid:
		ax.grid(linewidth='1.5', linestyle='dashed')
	if xn != None:
		ax.set_xlabel(xn, fontweight='bold')
	if yn != None:
		ax.set_ylabel(yn, fontweight='bold')
	if title != None:
		ax.set_title(title, fontweight='bold')
	return ax

def SetScatterProp(ax, xn=None, yn=None, title=None, legend = True, Loc = 'upper right'):
	fontsize = 14
	for axis in ['top','bottom','left','right']:
		ax.spines[axis].set_linewidth(2.5)

	ax.set_yticklabels([])
	ax.set_xticklabels([])

	if legend:   
		ax.legend(loc=Loc, shadow=True, prop={'weight':'bold'})

	if title != None:
		ax.set_title(title, fontweight='bold')
	return ax

def GetDirectory(Args):
	if Args.DataType == 'Syn2':
		if Args.TestType == 'MatchPair_SignTest':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_%s/%s2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_%s/'%\
					(Args.DataType, Args.Sep, Args.noise_var, Args.RespondingThres, Args.S, Args.Budget, Args.QS, Args.TestType, Args.Enrichmentcls, Args.Bettingcls, Args.SeqStartPoint, Args.Thres, Args.ScalingStrategy)
		elif Args.TestType == 'RegressionType_MatchPair_SignTest':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_%s/%s2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_%s/'%\
					(Args.DataType, Args.Sep, Args.noise_var,Args.RespondingThres, Args.S, Args.Budget, Args.QS, Args.TestType, Args.Bettingcls, Args.regressor, Args.SeqStartPoint, Args.ScalingStrategy)
		
		FigurePath = os.getcwd() + '/Figures/%s/'%(Args.DataType)

	if not os.path.exists(StatsPath):
		os.makedirs(StatsPath)	
	if not os.path.exists(FigurePath):
		os.makedirs(FigurePath)	
	return StatsPath, FigurePath

# evaluate the enrichment classifier
def GetEvalofCls(pred_enrollment, pred_positive, ResonseRegionTestData_Y):
	# TPR = np.mean(Pred_Labels[ResonseRegionTestData_Y == 1])
	TPR = np.sum(pred_enrollment[ResonseRegionTestData_Y == 1]) / np.sum(ResonseRegionTestData_Y == 1) if np.sum(ResonseRegionTestData_Y == 1) != 0 else np.nan
	FPR = np.sum(pred_enrollment[ResonseRegionTestData_Y == 0]) / np.sum(ResonseRegionTestData_Y == 0) if np.sum(ResonseRegionTestData_Y == 0) != 0 else np.nan
	Precisison = np.sum(pred_enrollment[ResonseRegionTestData_Y == 1]) / np.sum(pred_enrollment == 1) if np.sum(pred_enrollment == 1) != 0 else np.nan
	fscore = f1_score(ResonseRegionTestData_Y, pred_enrollment, average='binary', zero_division=0) 
	acc = np.mean(pred_positive == ResonseRegionTestData_Y)
	return TPR, FPR, Precisison, fscore, acc


"""
Construct loading path where results are loaded and printed
"""
def ConstructLoadingPath(args, method, Budget):
	EnrichmentClassifier = args.Enrichmentcls
	BettingClassifier = args.Bettingcls
	EnrichmentRegressor = args.regressor

	if args.DataType == 'Syn' or args.DataType == 'Syn2':
		if method == 'Passive_ONS': # change the following to load linear and nonlinear enrichment classifier seperately 
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_ONS/'%\
					(args.DataType, args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Passive_Lowerbound': # change the following to load linear and nonlinear enrichment classifier seperately 
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/Cls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_LowerBound/'%\
					(args.DataType,args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, EnrichmentClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Passive_MCE': # change the following to load linear and nonlinear enrichment classifier seperately 
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_MCE/'%\
					(args.DataType,args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Active/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_ONS/'%\
					(args.DataType,args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Active/MatchPair_SignTest2ST/Cls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_LowerBound/'%\
							(args.DataType,args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, EnrichmentClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Active/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_MCE/'%\
							(args.DataType,args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Regression_Active_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Active/RegressionType_MatchPair_SignTest2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_ONS/'%\
							(args.DataType,args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)
		elif method == 'Regression_Active_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Active/RegressionType_MatchPair_SignTest2ST/Cls%s_Reg%s/InitialTrSize%d/BettingFraction_LowerBound/'%\
							(args.DataType,args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)
		elif method == 'Regression_Active_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/Sep%.2f_noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Active/RegressionType_MatchPair_SignTest2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_MCE/'%\
				(args.DataType, args.Sep, args.noise_var, args.RespondingThres, args.S, Budget, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)
	elif args.DataType == 'Syn3':
		if method == 'Active_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/noisevar%.2f_RespondingThres%.2f/DataSize%d/Budget%d/QueryMethod_Active/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_MCE/'%\
							(args.DataType,args.noise_var, args.RespondingThres, args.S, Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)		
	elif args.DataType == 'RILUZOLEALS' or args.DataType == 'PrimaryDrug_FVC_ALSFRS_Slope':
		if method == 'Passive_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/RespondingThres%.3f/DataSize%d/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/Cls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_ONS/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Passive_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/RespondingThres%.3f/DataSize%d/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/Cls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_LowerBound/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Passive_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/RespondingThres%.3f/DataSize%d/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/Cls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_MCE/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_ONS/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/RespondingThres%.3f/DataSize%d/Budget%d/QueryMethod_Active/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_LowerBound/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_MCE/'%\
					(args.DataType, Budget, args.RespondingThres, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Regression_Active_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/RespondingThres%.3f/DataSize%d/Budget%d/QueryMethod_Active/RegressionType_MatchPair_SignTest2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_LowerBound/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, BettingClassifier, args.SeqStartPoint)
		elif method == 'Regression_Active_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/RespondingThres%.3f/DataSize%d/Budget%d/QueryMethod_Active/RegressionType_MatchPair_SignTest2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_MCE/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)
		elif method == 'Regression_Active_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/RespondingThres%.3f/DataSize%d/Budget%d/QueryMethod_Active/RegressionType_MatchPair_SignTest2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_ONS/'%\
					(args.DataType, args.RespondingThres, args.S, Budget, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)
	elif args.DataType in ['PrimaryDrug_ALSFRS_Slope',  'RILUZOLE_ALSFRS_Slope', 'RILUZOLE_Cov012_ALSFRS_Slope', 'longitudinal_IHDP']:
		if method == 'Passive_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Passive/%s2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/BettingFraction_ONS/'%\
					(args.DataType,  Budget,  args.TestType, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint)
		elif method == 'Passive_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/Cls%s/InitialTrSize%d/BettingFraction_LowerBound/'%\
					(args.DataType,  Budget,  BettingClassifier, args.SeqStartPoint)
		elif method == 'Passive_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Passive/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/BettingFraction_MCE/'%\
					(args.DataType,   Budget, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint)
		elif method == 'Active_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/%s2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_ONS/'%\
					(args.DataType,  Budget, args.RespondingThres, args.TestType, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_LowerBound/'%\
					(args.DataType,  Budget, args.RespondingThres, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Active_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/MatchPair_SignTest2ST/EnrichmentCls%s_BettingCls%s/InitialTrSize%d/AcquisitionThres%.2f/BettingFraction_MCE/'%\
					(args.DataType,  Budget, args.RespondingThres, EnrichmentClassifier, BettingClassifier, args.SeqStartPoint, args.Thres)
		elif method == 'Regression_Active_Lowerbound':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/RegressionType_MatchPair_SignTest2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_LowerBound/'%\
					(args.DataType,  Budget, args.RespondingThres, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)
		elif method == 'Regression_Active_MCE':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/RegressionType_MatchPair_SignTest2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_MCE/'%\
					(args.DataType,  Budget, args.RespondingThres, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)
		elif method == 'Regression_Active_ONS':
			StatsPath = os.getcwd() + '/Stats/%s/Budget%d/QueryMethod_Active/RespondingThres%.3f/RegressionType_%s2ST/BettingCls%s_Reg%s/InitialTrSize%d/BettingFraction_ONS/'%\
					(args.DataType, Budget, args.RespondingThres,  args.TestType, BettingClassifier, EnrichmentRegressor, args.SeqStartPoint)

	return StatsPath
"""
Comparing active to passive methods along various label budget
"""
def PlotResultsAlongBudgets(args):

	Methods = ['Passive_ONS', 'Active_ONS']
	Names = ['Passive_fraction1', 'Active_fraction1']
	# Set up budget and other variables
	if args.DataType == 'Syn2' :
		Budget = [100, 200, 300, 400, 500, 600, 700, 800]


	RejectMean_VariousMethods = np.zeros((len(Names), len(Budget)));
	LabelSpentMean_VariousMethods = np.zeros((len(Names), len(Budget)));
	LabelSpentStd_VariousMethods = np.zeros((len(Names), len(Budget)));

	# Load results of maximum allowed budget
	for v, m in enumerate(Methods): 
		# Construct loading path			
		StatsPath = ConstructLoadingPath(args, m, Budget[-1])
		# extract results for the largest budget
		with open(StatsPath + "stats.txt", "r") as f:
			A = f.readlines()
			Reject = np.zeros(len(A)); Label_Spent = np.zeros(len(A))
			for i, r in enumerate(A):
				r_split = r.split(' ')
				Reject[i] = r_split[14]; Label_Spent[i] = np.float32(r_split[18][:-1])
				
		# Mapping larget budget result to various budget
		for u, b in enumerate(Budget):
			Reject_thisbudget = np.zeros(len(Reject))
			Label_Spent_thisbudget = np.zeros(len(Label_Spent))
			for j in range(len(Reject)):
				if Label_Spent[j] > b:
					Reject_thisbudget[j] = 0; Label_Spent_thisbudget[j] = b 
				else:
					Reject_thisbudget[j] = Reject[j]; Label_Spent_thisbudget[j] = Label_Spent[j]
			RejectMean_VariousMethods[v, u] = np.mean(Reject_thisbudget)
			LabelSpentMean_VariousMethods[v, u] = np.mean(Label_Spent_thisbudget)
			LabelSpentStd_VariousMethods[v, u] = np.std(Label_Spent_thisbudget)


	# Get the best statistic
	Best_RejectMean_VariousMethods = np.max(RejectMean_VariousMethods, axis = 0)
	Best_LabelSpentMean_VariousMethods = np.min(LabelSpentMean_VariousMethods, axis = 0)
	Best_LabelSpentStd_VariousMethods = np.max(LabelSpentStd_VariousMethods, axis = 0)

	# Print results of Type II error
	print('===================Results of testing power for various methods===================')
	for v, m in enumerate(Names): 			
		for u, b in enumerate(Budget):
			if u == 0:
				if u == len(Budget)- 1:
					if RejectMean_VariousMethods[v, u] == Best_RejectMean_VariousMethods[u]:
						print('%s & \\textbf{%.2f}\\\\'%(m, RejectMean_VariousMethods[v, u]))
					else:
						print('%s & %.2f\\\\'%(m, RejectMean_VariousMethods[v, u]))
				else:
					if RejectMean_VariousMethods[v, u] == Best_RejectMean_VariousMethods[u]:
						print('%s & \\textbf{%.2f}&'%(m, RejectMean_VariousMethods[v, u]), end = ' ')
					else:
						print('%s & %.2f&'%(m, RejectMean_VariousMethods[v, u]), end = ' ')
			elif u == len(Budget)- 1:
				if RejectMean_VariousMethods[v, u] == Best_RejectMean_VariousMethods[u]:
					print('\\textbf{%.2f}\\\\'%(RejectMean_VariousMethods[v, u]))
				else:
					print('%.2f\\\\'%(RejectMean_VariousMethods[v, u]))
			else:
				if RejectMean_VariousMethods[v, u] == Best_RejectMean_VariousMethods[u]:
					print('\\textbf{%.2f}&'%(RejectMean_VariousMethods[v, u]), end = ' ')
				else:
					print('%.2f&'%(RejectMean_VariousMethods[v, u]), end = ' ')

	# Print results of Label spent
	print('===================Results of Label spent for various methods==================')
	for v, m in enumerate(Names): 			
		for u, b in enumerate(Budget):
			if u == 0:
				if u == len(Budget)- 1:
					if LabelSpentMean_VariousMethods[v, u] == Best_LabelSpentMean_VariousMethods[u]:
						print('%s & \\textbf{%.2f}$\\pm$%.2f\\\\'%(m, LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]))
					else:
						print('%s &%.2f$\\pm$%.2f\\\\'%(m, LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]))
				else:
					if LabelSpentMean_VariousMethods[v, u] == Best_LabelSpentMean_VariousMethods[u]:
						print('%s & \\textbf{%.2f}$\\pm$%.2f&'%(m, LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]), end = ' ')
					else:
						print('%s &%.2f$\\pm$%.2f&'%(m, LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]), end = ' ')
			elif u == len(Budget)- 1:
				if LabelSpentMean_VariousMethods[v, u] == Best_LabelSpentMean_VariousMethods[u]:
					print('\\textbf{%.2f}$\\pm$%.2f\\\\'%(LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]))
				else:
					print('%.2f$\\pm$%.2f\\\\'%(LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]))
			else:
				if LabelSpentMean_VariousMethods[v, u] == Best_LabelSpentMean_VariousMethods[u]:
					print('\\textbf{%.2f}$\\pm$%.2f'%(LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]), end = ' ')
				else:
					print('%.2f$\\pm$%.2f'%(LabelSpentMean_VariousMethods[v, u], LabelSpentStd_VariousMethods[v, u]), end = ' ')

"""
Type I Error
"""
def PlotTypeIAlongBudgets(args, FigurePath):
	# Set up budget and other variables
	Budget = [100, 200, 300, 400, 500, 600, 800]
	
	m = 'Active_ONS'
	StatsPath = ConstructLoadingPath(args, m, Budget[-1])
	RejectMean = np.zeros(len(Budget))
	# extract results for the largest budget
	with open(StatsPath + "stats.txt", "r") as f:
		A = f.readlines()
		print(len(A))
		Reject = np.zeros(len(A)); Label_Spent = np.zeros(len(A))
		for i, r in enumerate(A):
			r_split = r.split(' ')
			Reject[i] = r_split[14]; Label_Spent[i] = np.float32(r_split[18][:-1])
				
	# Mapping larget budget result to various budget
	for u, b in enumerate(Budget):
		Reject_thisbudget = np.zeros(len(Reject))
		Label_Spent_thisbudget = np.zeros(len(Label_Spent))
		for j in range(len(Reject)):
			if Label_Spent[j] > b:
				Reject_thisbudget[j] = 0; Label_Spent_thisbudget[j] = b 
			else:
				Reject_thisbudget[j] = Reject[j]; Label_Spent_thisbudget[j] = Label_Spent[j]
		RejectMean[u] = np.mean(Reject_thisbudget)
	print(RejectMean)
	Fig = plt.figure(); ax = Fig.gca();
	ax.plot(np.array(Budget), RejectMean, marker='o', color = 'blue', label= 'MPED-RobustCAL')
	ax.plot(np.array(Budget), np.ones(len(Budget)) * 0.05, color = 'red', label = r'$\alpha = 0.05$' )
	ax = SetPltProp(ax, xn='Label Budget', pos='best', yn='Type I Error')
	Fig.savefig(FigurePath + '/SynTypeIError.png', bbox_inches='tight')

"""
Plot accuracy for active learning and passive learning
"""
def plot_acc_passive_and_active(args, FigurePath):
	Methods = [ 'Active_ONS',  'Passive_ONS']
	Method_Label = ['MPED-RobustCAL',   'Passive learning']
	Color = ['r', 'b']  # Define a color palette


	# Load results of maximum allowed budget
	Fig = plt.figure(); ax= Fig.gca(); # effect size 


	for mlabel, m, a_color in zip(Method_Label,Methods, Color): 
		StatsPath = ConstructLoadingPath(args, m, args.Budget)
		acc_along_labelspent = np.zeros((args.Trial, args.Budget))
		# The following is solely for IHDP. Uncomment above for other datasets.
		# acc_along_labelspent = np.zeros((args.Trial, 512))
		for i in range(args.Trial):
			saved_acc = np.load(StatsPath + 'acc_along_labelspent%d.npy'%(i + 1)).reshape(-1)[:args.Budget]
			acc_along_labelspent[i, :len(saved_acc)] = saved_acc
		
		# average acc from multiple runs 
		mean_acc_along_labelspent = np.mean(acc_along_labelspent, axis = 0)
		valid_indices = np.where(mean_acc_along_labelspent != 0)[0][:300]

		ax.fill_between(valid_indices, 
							np.maximum(mean_acc_along_labelspent[valid_indices] - np.std(acc_along_labelspent[:, valid_indices], axis=0), 0), 
							np.minimum(mean_acc_along_labelspent[valid_indices] + np.std(acc_along_labelspent[:, valid_indices], axis=0), 1), 
							color=a_color, alpha=0.2)
		ax.plot(np.arange(args.Budget)[valid_indices], mean_acc_along_labelspent[valid_indices], linewidth=3, color=a_color, label=mlabel)


	ax = SetPltProp(ax, xn='Number of labels spent', pos='best', yn='Accuracy')

	ax.set_ylim(0, 1.05)
	ax = SetPltProp(ax, xn='Number of labels spent', pos='best', yn='Effect size')
	Fig.savefig(FigurePath + '/acc_passive_and_active_%s.png'%(args.Enrichmentcls), bbox_inches='tight')

"""
Plot the effect size curve along the label number spent
"""
def PlotEffectSizeAlongLabels(args, FigurePath):
	Methods = [ 'Active_ONS',  'Passive_ONS', 'Regression_Active_ONS',]
	Method_Label = ['MPED-RobustCAL',   'Passive learning',  'Active Design based on Regression']
	Color = ['r', 'b', 'b']  # Define a color palette

	# Load results of maximum allowed budget
	Fig = plt.figure(); ax= Fig.gca(); # effect size 
	Fig1 = plt.figure(); ax1= Fig1.gca(); # TPR for regression-based learning and active learning
	Fig2 = plt.figure(); ax2= Fig2.gca(); # Predicion for active learning and passive learning
	Fig3 = plt.figure(); ax3= Fig3.gca(); # TPR for passive and active learning
	Fig4 = plt.figure(); ax4= Fig4.gca(); # Acc for passive and active learning 

	for mlabel, m, a_color in zip(Method_Label,Methods, Color): 
		EffectSize_Along_LabelSpent = np.zeros((args.Trial, args.Budget))
		TPR_Along_LabelSpent = np.zeros((args.Trial, args.Budget))
		Precision_Along_LabelSpent = np.zeros((args.Trial, args.Budget))
		acc_along_labelspent = np.zeros((args.Trial, args.Budget))

		SumTPR_Along_LabelSpent = np.zeros((args.Budget))
		SumPrecision_Along_LabelSpent = np.zeros(( args.Budget))

		StatsPath = ConstructLoadingPath(args, m, args.Budget)
		TFRCount_Along_Labelspent = np.zeros(args.Budget)
		PrecisionCount_Along_Labelspent = np.zeros(args.Budget)

		for i in range(args.Trial):

			Saved_EffectSize = np.load(StatsPath + 'EffectSize_Along_LabelSpent%d.npy'%(i + 1)).reshape(-1)[:args.Budget]
			Saved_TPR = np.load(StatsPath + 'TPR_Along_LabelSpent%d.npy'%(i + 1)).reshape(-1)[:args.Budget]
			Saved_Precision = np.load(StatsPath + 'Precision_Along_LabelSpent%d.npy'%(i + 1)).reshape(-1)[:args.Budget]
			saved_acc = np.load(StatsPath + 'acc_along_labelspent%d.npy'%(i + 1)).reshape(-1)[:args.Budget]

			EffectSize_Along_LabelSpent[i, :len(Saved_EffectSize)] = Saved_EffectSize
			for t in range(len(Saved_Precision)):
				if Saved_TPR[t] != 0 or Saved_Precision[t] != 0:
					if not math.isnan(Saved_Precision[t]):
						SumPrecision_Along_LabelSpent[t]+=Saved_Precision[t]
						PrecisionCount_Along_Labelspent[t]+=1
						TFRCount_Along_Labelspent[t]+=1
						SumTPR_Along_LabelSpent[t]+=Saved_TPR[t]

			TPR_Along_LabelSpent[i, :len(Saved_TPR)] = Saved_TPR
			Precision_Along_LabelSpent[i, :len(Saved_Precision)] = Saved_Precision
			acc_along_labelspent[i, :len(saved_acc)] = saved_acc
		
		# average metrics from multiple runs 
		Mean_TPR_Along_LabelSpent = np.nanmean(TPR_Along_LabelSpent, axis = 0)
		Mean_Precision_Along_LabelSpent = np.nanmean(Precision_Along_LabelSpent, axis = 0)

		Mean_EffectSize_Along_LabelSpent = np.mean(EffectSize_Along_LabelSpent, axis = 0)
		mean_acc_along_labelspent = np.mean(acc_along_labelspent, axis = 0)
		

		Groups_Mean_EffectSize_Along_LabelSpent = np.mean(Mean_EffectSize_Along_LabelSpent[150:450].reshape(-1, 1), axis=1)
		ax.plot(np.arange(len(Groups_Mean_EffectSize_Along_LabelSpent)), Groups_Mean_EffectSize_Along_LabelSpent, label = m)

		valid_indices = np.where(TFRCount_Along_Labelspent != 0)[0][:400]
		if not m in ['Passive_ONS', 'Passive_MCE']:
			ax1.fill_between(valid_indices, 
								np.maximum(Mean_TPR_Along_LabelSpent[valid_indices] - np.nanstd(TPR_Along_LabelSpent[:, valid_indices], axis=0), 0), 
								np.minimum(Mean_TPR_Along_LabelSpent[valid_indices] + np.nanstd(TPR_Along_LabelSpent[:, valid_indices], axis=0), 1), 
								color=a_color, alpha=0.2)
			ax1.plot(np.arange(args.Budget)[valid_indices], Mean_TPR_Along_LabelSpent[valid_indices], linewidth=3, color=a_color, label=mlabel)
		if not m in ['Regression_Active_ONS', 'Regression_Active_MCE']:
			ax2.fill_between(np.arange(args.Budget)[valid_indices], 
								np.maximum(Mean_Precision_Along_LabelSpent[valid_indices] - np.nanstd(Precision_Along_LabelSpent[:, valid_indices], axis=0), 0), 
								np.minimum(Mean_Precision_Along_LabelSpent[valid_indices] + np.nanstd(Precision_Along_LabelSpent[:, valid_indices], axis=0), 1), 
								color=a_color, alpha=0.2)
			ax2.plot(np.arange(args.Budget)[valid_indices], 
						Mean_Precision_Along_LabelSpent[valid_indices], 
						linewidth=3, color=a_color, label=mlabel)
			
			ax3.fill_between(valid_indices, 
								np.maximum(Mean_TPR_Along_LabelSpent[valid_indices] - np.nanstd(TPR_Along_LabelSpent[:, valid_indices], axis=0), 0), 
								np.minimum(Mean_TPR_Along_LabelSpent[valid_indices] + np.nanstd(TPR_Along_LabelSpent[:, valid_indices], axis=0), 1), 
								color=a_color, alpha=0.2)
			ax3.plot(np.arange(args.Budget)[valid_indices], Mean_TPR_Along_LabelSpent[valid_indices], linewidth=3, color=a_color, label=mlabel)

			ax4.fill_between(valid_indices, 
								np.maximum(mean_acc_along_labelspent[valid_indices] - np.std(acc_along_labelspent[:, valid_indices], axis=0), 0), 
								np.minimum(mean_acc_along_labelspent[valid_indices] + np.std(acc_along_labelspent[:, valid_indices], axis=0), 1), 
								color=a_color, alpha=0.2)
			ax4.plot(np.arange(args.Budget)[valid_indices], mean_acc_along_labelspent[valid_indices], linewidth=3, color=a_color, label=mlabel)


	ax1 = SetPltProp(ax1, xn='Number of labels spent', pos='best', yn='TPR')
	ax2 = SetPltProp(ax2, xn='Number of labels spent', pos='best', yn='Precision')
	ax3 = SetPltProp(ax3, xn='Number of labels spent', pos='best', yn='TPR')
	ax4 = SetPltProp(ax4, xn='Number of labels spent', pos='best', yn='Accuracy')

	ax1.set_ylim(0, 1.05)
	ax2.set_ylim(0, 0.6)
	ax3.set_ylim(0, 1.05)
	ax4.set_ylim(0, 1.05)
	ax = SetPltProp(ax, xn='Number of labels spent', pos='best', yn='Effect size')
	Fig1.savefig(FigurePath + '/True Positive Rate_%s.png'%(args.regressor), bbox_inches='tight')
	Fig2.savefig(FigurePath + '/Precision_%s.png'%(args.regressor), bbox_inches='tight')
	Fig.savefig(FigurePath + '/EffectSize_along_labelspent_%s.png'%(args.regressor), bbox_inches='tight')
	Fig3.savefig(FigurePath + '/tpr_passive_and_active_%s.png'%(args.regressor), bbox_inches='tight')
	Fig4.savefig(FigurePath + '/acc_passive_and_active_%s.png'%(args.Enrichmentcls), bbox_inches='tight')
# plot type-II error and label spent for various methods

	with open(StatsPath + "stats.txt", "r") as f:
		A = f.readlines()
		Reject = np.zeros(len(A)); Label_Spent = np.zeros(len(A))
		TPR = np.zeros(len(A)); FPR = np.zeros(len(A)); Fscore = np.zeros(len(A))
		for i, r in enumerate(A):
			r_split = r.split(' ')
			Reject[i] = r_split[14]; Label_Spent[i] = np.float32(r_split[18][:-1])
			TPR[i] = np.float32(r_split[20][:-1]); FPR[i] = np.float32(r_split[22][:-1])
			Fscore[i] = np.float32(r_split[24])
	print('Type II error: %.4f, label spent: %.2f, TPR: %.4f, FPR: %.4f, FSCORE: %.4f, '%(1 - np.mean(Reject), np.mean(Label_Spent), np.mean(TPR), np.mean(FPR), np.mean(Fscore)))

"""
Estimate effect size
"""
def EstimateEffectSize(MatchPairExpData, QueryIndex):
	SelectedData = MatchPairExpData[QueryIndex]
	Response_Difference = 0
	for i in range(len(SelectedData)):
		if SelectedData[i, -2] == 1:
			Response_Difference+= (SelectedData[i, -4] - SelectedData[i, -5])
		else:
			Response_Difference+= (SelectedData[i, -5] - SelectedData[i, -4])
	Avg_Response_Difference = Response_Difference / len(SelectedData) 
	return Avg_Response_Difference

# Draw Synthetic Data and its experimental results
def Draw_SyntheticData_Results(args, FigurePath):
	# Construct saving path and loading the data
	FigurePath2 = FigurePath + 'Covariate_Visualization/'
	if not os.path.exists(FigurePath2):
		os.makedirs(FigurePath2)
	MatchPairExpData, EnrichmentClsTestingData = GetMatchDataByDistance(args)

	# Draw noisy data
	Feat = MatchPairExpData[:, :2]
	Label = MatchPairExpData[:, -1]

	# Draw original pair match data (Only half of them) in classification view
	Fig = plt.figure(); ax = Fig.gca()
	ax.scatter(Feat[Label == 0, 0], Feat[Label == 0, 1], c = 'b', label = 'Class 0', s = 30)
	ax.scatter(Feat[Label == 1, 0], Feat[Label == 1, 1], c = 'r', label = 'Class 1', s = 30)
	ax = SetPltProp(ax, xn="$X_{1}$", yn="$X_{2}$", grid=False, legend = True, pos = 'upper right')
	ax.set_aspect(aspect='equal')
	Fig.savefig(FigurePath2 + 'Sep%.2f_NoisyResponseNoiseVar%.2f_Trial%d.png'%(args.Sep, args.noise_var, args.Trial), bbox_inches='tight')
	plt.close('all')

	# Recalibrate the classification labels in match data to bayesian classification labels 
	MatchPairExpData[:, -1] = 0
	if args.DataType == 'Syn2':
		for i in range(len(MatchPairExpData)):
			if (MatchPairExpData[i, 0] + args.Sep < MatchPairExpData[i, 1]):
				MatchPairExpData[i, -1] = 1
	Feat = MatchPairExpData[:, :2]
	Label = MatchPairExpData[:, -1]

	# Draw original pair match data (Only half of them) in classification view
	Fig = plt.figure(); ax = Fig.gca()
	ax.scatter(Feat[Label == 0, 0], Feat[Label == 0, 1], c = 'b', label = 'Class 0', s = 30)
	ax.scatter(Feat[Label == 1, 0], Feat[Label == 1, 1], c = 'r', label = 'Class 1', s = 30)
	ax = SetPltProp(ax, xn="$X_{1}$", yn="$X_{2}$", grid=False, legend = True, pos = 'upper right')
	ax.set_aspect(aspect='equal')
	Fig.savefig(FigurePath2 + 'Sep%.2f_CleanResponseNoiseVar%.2f_Trial%d.png'%(args.Sep, args.noise_var, args.Trial), bbox_inches='tight')
	plt.close('all')

	# Load querying indices
	# Load query index and associated covariates
	Acive_MCE_Path = ConstructLoadingPath(args, 'Active_MCE', args.Budget)
	Passive_MCE_Path = ConstructLoadingPath(args, 'Passive_MCE', args.Budget)
	Regression_Active_MCE_Path = ConstructLoadingPath(args, 'Regression_Active_MCE', args.Budget)

	# PassiveQueryIndex = np.load(PassiveStatsPath + 'QueryIndex%d.npy'%args.Trial)[args.SeqStartPoint:]
	# ActiveQueryIndex = np.load(ActiveStatsPath + 'QueryIndex%d.npy'%args.Trial)[args.SeqStartPoint:]

	PassiveQueryIndex = np.load(Passive_MCE_Path + 'QueryIndex%d.npy'%args.Trial)[300:450]
	ActiveQueryIndex = np.load(Acive_MCE_Path + 'QueryIndex%d.npy'%args.Trial)[300:450]
	RegressionctiveQueryIndex = np.load(Regression_Active_MCE_Path + 'QueryIndex%d.npy'%args.Trial)[300:450]

	Passive_Covaraites = MatchPairExpData[PassiveQueryIndex, :2].reshape((-1, 2))
	Active_Covaraites = MatchPairExpData[ActiveQueryIndex, :2].reshape((-1, 2))
	Regression_Active_Covaraites = MatchPairExpData[RegressionctiveQueryIndex, :2].reshape((-1, 2))

	QueryMethods= ['Passive', 'Active', 'Regression_Active']
	QueriedCovariates = [Passive_Covaraites, Active_Covaraites, Regression_Active_Covaraites]
	# Draw passive and active query
	for i, m in enumerate(QueryMethods):
		Fig = plt.figure(); ax = Fig.gca()
		# Draw original pair match data (Only half of them) in classification view
		ax.scatter(Feat[Label == 0, 0], Feat[Label == 0, 1], c = 'b', label = 'Class 0', s = 30)
		ax.scatter(Feat[Label == 1, 0], Feat[Label == 1, 1], c = 'r', label = 'Class 1', s = 30)
		QueriedCovariates2 = QueriedCovariates[i]
		
		ax.scatter(QueriedCovariates2[:, 0], QueriedCovariates2[:, 1], c = 'g', label = 'Queried', s = 30)

		ax = SetPltProp(ax, xn="$X_{1}$", yn="$X_{2}$", grid=False, legend = True, pos = 'upper right')
		ax.set_aspect(aspect='equal')
		Fig.savefig(FigurePath2 + 'Sep%.2f_ResponseNoiseVar%.2f_%s_QueryResults%d.png'%(args.Sep, args.noise_var, m, args.Trial), bbox_inches='tight')
		plt.close('all')
	

	# Set up paths
	FigurePath = FigurePath+ 'TypeI/X-axis-sample-size/Cls%s/'%(args.cls)
	# Per = np.arange(args.Interval, args.Per + args.Interval, args.Interval); 

	if not os.path.exists(FigurePath):
		os.makedirs(FigurePath)

	# MethodLabel = ['CS2T', 'KernelMMD', 'ActiveSign-ONS', 'ActiveSign-Ours']

	# TestType = ['CS2T', 'KernelMMD', 'SignTest', 'SignTest']

	MethodLabel = ['CS2T','ActiveSign-Ours']

	TestType = ['CS2T', 'SignTest']

	Color = ['r', 'b', 'c', 'm', 'y', 'lightcoral', 'teal', 'orange', 'green']; 
	Cnum = 0	
	Fig1 = plt.figure(); ax1= Fig1.gca();

	SampleSize = [200, 400, 600]
	Sep = [0]

	# Color = ['r', 'r', 'r', 'b', 'b', 'lightcoral', 'teal', 'orange', 'green']
	# Markers = ['.', 'o', 'v', '^', '<']
	for sep in Sep:
		Fig1 = plt.figure(); ax1= Fig1.gca();
		Fig2 = plt.figure(); ax2= Fig2.gca();
		Cnum = 0; Err = np.zeros(len(SampleSize)); Stop = np.zeros((len(SampleSize)))
		for tt, m in zip(TestType, MethodLabel):
			Err = np.zeros(len(SampleSize)); Stop = np.zeros((len(SampleSize)))
			Reject = np.zeros(len(SampleSize)); Low_CI = np.zeros((len(SampleSize))); Upp_CI = np.zeros((len(SampleSize)))
			for j, s in enumerate(SampleSize):			
				if args.DataType == 'Syn':
					if m == 'FR' or m == 'KernelMMD':
						StatsPath = os.getcwd() + '/Stats/%s/Observation2/DataSize%d/ES%.2f/%s2ST/'%(args.DataType, s, sep, tt)
					elif m == 'LR' or m =='LR2' or m == 'CS2T':
						StatsPath = os.getcwd() + '/Stats/%s/Observation2/DataSize%d/ES%.2f/%s2ST/%sCls/'%(args.DataType,  s, sep, tt, args.cls)
					elif m == 'ActiveSign-ONS':
						StatsPath = os.getcwd() + '/Stats/%s/Observation2/DataSize%d/ES%.2f/%s2ST/ONS/%sCls/'%(args.DataType,  s, sep, tt, args.cls)
					elif m == 'ActiveSign-MCE (ours)':
						StatsPath = os.getcwd() + '/Stats/%s/Observation2/DataSize%d/ES%.2f/SignTest2ST/MCE/%sCls/'%(args.DataType, s, sep, args.cls)
					elif m == 'ActiveSign-ours':
						StatsPath = os.getcwd() + '/Stats/%s/Observation2/DataSize%d/ES%.2f/%s2ST/LowerBound/%sCls/'%(args.DataType,  s, sep, tt, args.cls)
					elif m == 'PassiveSign-LB':
						StatsPath = os.getcwd() + '/Stats/%s/Observation2/DataSize%d/ES%.2f/%s2ST/LowerBound/%sCls/'%(args.DataType,  s, sep, tt, args.cls)			
				else:
					if m == 'FR' or m == 'KernelMMD':
						StatsPath = os.getcwd() + '/Stats/%s/DataSize%d/%s2ST/'%(args.DataType, s, tt)
					elif m == 'LR' or m =='LR2' or m == 'CS2T':
						StatsPath = os.getcwd() + '/Stats/%s/DataSize%d/%s2ST/%sCls/'%(args.DataType,  s, tt, args.cls)
					elif m == 'ActiveSign-ONS':
						StatsPath = os.getcwd() + '/Stats/%s/DataSize%d/%s2ST/ONS/%sCls/'%(args.DataType,  s, tt, args.cls)
					elif m == 'ActiveSign-MCE (ours)':
						StatsPath = os.getcwd() + '/Stats/%s/DataSize%d/SignTest2ST/MCE/%sCls/'%(args.DataType, s, args.cls)
					elif m == 'ActiveSign-ours':
						StatsPath = os.getcwd() + '/Stats/%s/DataSize%d/%s2ST/LowerBound/%sCls/'%(args.DataType,  s, tt, args.cls)
					elif m == 'PassiveSign-LB':
						StatsPath = os.getcwd() + '/Stats/%s/DataSize%d/%s2ST/LowerBound/%sCls/'%(args.DataType,  s,  tt, args.cls)	

				for t in range(args.Trial):
				
					Stats = np.load(StatsPath + 'StatsTrial%d.npy'%(t + 1));
					Reject[j]+= Stats[1]
					Stop[j]+= Stats[0]


			
				Err[j] = Reject[j]/args.Trial; 
				Stop[j] = Stop[j]/args.Trial
			

			for i in range(len(SampleSize)):
				Low_CI[i], Upp_CI[i] = proportion_confint(Reject[i], args.Trial, alpha = 0.05, method='wilson')

			ax1.plot(SampleSize, Stop, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			# ax2.plot(SampleSize, 1 - Err, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			ax2.errorbar(SampleSize, Err, yerr=[Err - Low_CI, Upp_CI- Err], 
				         label=m, color=Color[Cnum], capsize=3, linestyle="None",
				         marker="s", markersize=8, mfc=Color[Cnum], mec=Color[Cnum])				
			print('test method: %s, Classifier:%s'%(m, args.cls))
			
			ax1 = SetPltProp(ax1, xn='Sample Size', yn='Stopping time', pos='best')
			ax2 = SetPltProp(ax2, xn='Sample Size', yn='Type I error', pos='best')

			Fig1.savefig(FigurePath + 'SampleSize_VS_StoppingTime.png', pos='best')
			Fig2.savefig(FigurePath + 'SampleSize_VS_TypeI.png', pos='best')
			
			plt.close('all')

			Cnum+=1

	

	MatchPairExpData, EnrichmentClsTestingData  = GetRealData(args)
	CovLen = int((MatchPairExpData.shape[-1] - 5)/2)
	# for i in range(9):
	Feat = MatchPairExpData[:, :CovLen]; Labels = MatchPairExpData[:, -1]
	# Feat_Transformed = KernelPCA(n_components=5).fit_transform(Feat)
	Fdiv = FDivergence(Feat[Labels==0], Feat[Labels==1])
	print('F-divergence:%.5f'%Fdiv)